#perl
#==============================================================================
#
#  Faktories und Mocks
#
#  DiContainer
#
#  Im DiContainer knnen Methoden hinterlegt werden,
#  die ein Element erzeugen oder die zurckzuliefernden Objekte selbst.
#
#==============================================================================

use warnings;
use strict;

$|=1;

package DiContainer;

#------------------------------------------------------------------------------
#  Konstruktor
#------------------------------------------------------------------------------
sub new {
    my $self = shift;

    my $type = ref($self)  ||  $self;
    my $elem = bless {}, $type;

    $elem->init();

    return $elem;
}

#------------------------------------------------------------------------------
#  Initialisierung
#------------------------------------------------------------------------------
sub init {
    my $self = shift;
    $self->{container} = {};
}

#------------------------------------------------------------------------------
#  Closure fr Create ablegen
#------------------------------------------------------------------------------
sub DepositForCreate
{
    my $self = shift;

    my $caller    = shift;
    my $interface = shift;
    my $closure   = shift;

    my $key = $self->CreateKey("Create", $caller, $interface);

    $self->{container}->{$key} = $closure;
}

#------------------------------------------------------------------------------
# Key erzeugen
#------------------------------------------------------------------------------
sub CreateKey {
    my $self = shift;

    my $function       = shift;
    my $caller         = shift;
    my $interface      = shift;

    my $callerClass = ref($caller)  ||  $caller;

    return "$function.$callerClass.$interface";
}

#------------------------------------------------------------------------------
# Closure abholen
#------------------------------------------------------------------------------
sub GetClosure {
    my $self = shift;

    my $function       = shift;
    my $caller         = shift;
    my $interface      = shift;

    my $key = $self->CreateKey($function, $caller, $interface);

    return $self->{container}->{$key};
}

#------------------------------------------------------------------------------
#  Element mit hinterlegter Sub erzeugen, statt new aufzurufen
#------------------------------------------------------------------------------
sub Create {
    my $self = shift;

    my $caller         = shift;
    my $interface      = shift;
    my $defaultCreator = shift;

    my $creatorSub = $self->GetClosure("Create", $caller, $interface);

    my $callerClass = ref($caller)  ||  $caller; # nur fr Testausgabe!!

    if ($creatorSub)
    {
        print "DiContainer: verwende hinterlegte Closure fuer '$callerClass'\n"
            ."als Factory-Methode fuer Interface '$interface'.\n";
        return &$creatorSub;
    } 

    print "DiContainer: verwende default Factory-Methode fuer '$callerClass'\n"
        ."als Interface '$interface'.\n";

    return &$defaultCreator;
}

1;
