#perl
#==============================================================================
#
#  Faktories und Mocks
#
#  WordCounter, Version 8
#
#  Der Reader laesst einen Web-Reader aus dem Web lesen,
#  den er von einer Factory erzeugen lsst.
#  Als Factory wird eine globale Factory verwendet.
#  Die Analyse fhrt er dann selbst durch, in einer zweiten Methode.
#
#  Der WordCounter muss ab jetzt nicht mehr verndert werden,
#  um ihn testen zu knnen.
#
#  $content ist nicht zugreifbar!
#
#==============================================================================

use warnings;
use strict;

$|=1;

package WordCounter;

use WebReader;

our $DiContainer; # Forward-Declaration

#------------------------------------------------------------------------------
#  Konstruktor
#------------------------------------------------------------------------------
sub new {
    my $self = shift;

    my $type = ref($self)  ||  $self;
    my $elem = bless {}, $type;

    $DiContainer = &main::GetDiContainer($self);
    die "Kein DiContainer gesetzt!" unless defined $DiContainer;

    return $elem;
}

#------------------------------------------------------------------------------
#  Count Words of Web File
#------------------------------------------------------------------------------
sub CountWordsOfWebFile {
    my $self         = shift;
    my $remote_file  = shift;
    my $minimalCount = shift;

    # my $webReader = new WebReader(); # Stattdessen den unteren Code ausfuehren
    my $webReader = $DiContainer->Create
        ($self,            # fuer welche Klasse hinterlegt
         "IWebReader",     # Schnittstelle des zurckgelieferten Objekts
	
        # Wenn nichts hinterlegt wurde
        sub { return new WebReader(); } 
        );

    my $content = $webReader->ReadWebFile($remote_file);

    $self->Analyse($content, $minimalCount);
}

#------------------------------------------------------------------------------
#  Analysieren der Daten
#------------------------------------------------------------------------------

sub Analyse {
    my $self         = shift;
    my $content      = shift;
    my $minimalCount = shift;

    print "Starte Analyse ... \n";

    my %words;

    my @wordList = split(/\W/, $content);   # \W trennt auf nicht-Wort-Zeichen
    foreach my $word (@wordList)            # Einzelne Wrter in @wordList
    {      
	if (length($word) > 0)
	{
	    $words{$word} = 0 unless defined $words{$word};
	    $words{$word}++;    # Einklinken in Hash
	}
    }

    my @keys = sort(keys(%words));

    print "Gefundene Woerter ".$#keys." \n";

    foreach my $word (@keys)
    {
        printf ("%4s '$word', ", $words{$word}) if $words{$word} > $minimalCount;
    }

    print "\n";
}

1;
