#perl
#==============================================================================
#
#  Faktories und Mocks
#
#  WordCounter2
#
#  Der Reader liest selbst aus dem Web und analysiert in zweiten Methode
#  $content ist leider nicht zugreifbar
#
#==============================================================================

use warnings;
use strict;

$|=1;

package WordCounter2;

use LWP::Simple;

#------------------------------------------------------------------------------
#  Konstruktor
#------------------------------------------------------------------------------
sub new {
    my $self = shift;

    my $type = ref($self)  ||  $self;
    my $elem = bless {}, $type;
    return $elem;
}

#------------------------------------------------------------------------------
#  Count Words of Web File
#------------------------------------------------------------------------------
sub CountWordsOfWebFile {
    my $self         = shift;
    my $remote_file  = shift;
    my $minimalCount = shift;

    print "Lese URL $remote_file ...\n";

    my $content = &get($remote_file);       # Selbst aus dem Web lesen
                                            # das ist schwer zu testen
    $self->Analyse($content, $minimalCount);
}

#------------------------------------------------------------------------------
#  Analysieren der Daten
#------------------------------------------------------------------------------

sub Analyse {
    my $self         = shift;
    my $content      = shift;
    my $minimalCount = shift;

    print "Starte Analyse ... \n";

    my %words;

    my @wordList = split(/\W/, $content);   # \W trennt auf nicht-Wort-Zeichen
    foreach my $word (@wordList)            # Einzelne Wrter in @wordList
    {        
        if (length($word) > 0)
	{
	    $words{$word} = 0 unless defined $words{$word};
	    $words{$word}++;    # Einklinken in Hash
	}
    }

    my @keys = sort(keys(%words));

    print "Gefundene Woerter ".$#keys." \n";

    foreach my $word (@keys)
    {
        printf ("%4s '$word', ", $words{$word}) if $words{$word} > $minimalCount;
    }

    print "\n";
}

1;
