#perl
#==============================================================================
#
#  Faktories und Mocks
#
#  WordCounter4
#
#  Der Reader laesst einen Web-Reader aus dem Web lesen,
#  den er aber selbst mit new erzeugt. 
#  Die Analyse fhrt er dann selbst durch, in einer zweiten Methode
#
#  $content ist nicht zugreifbar!
#
#==============================================================================

use warnings;
use strict;

$|=1;

package WordCounter4;

use WebReader;

# use LWP::Simple; # wird hier nicht mehr bentigt

#------------------------------------------------------------------------------
#  Konstruktor
#------------------------------------------------------------------------------
sub new {
    my $self = shift;

    my $type = ref($self)  ||  $self;
    my $elem = bless {}, $type; 
    return $elem;
}

#------------------------------------------------------------------------------
#  Count Words of Web File
#------------------------------------------------------------------------------
sub CountWordsOfWebFile {
    my $self         = shift;
    my $remote_file  = shift;
    my $minimalCount = shift;

    # Den webReader selbst zu erzeugen, das verhindert Mocking!
    my $webReader = new WebReader();
    my $content = $webReader->ReadWebFile($remote_file);

    $self->Analyse($content, $minimalCount);
}

#------------------------------------------------------------------------------
#  Analysieren der Daten
#------------------------------------------------------------------------------

sub Analyse {
    my $self         = shift;
    my $content      = shift;
    my $minimalCount = shift;

    print "Starte Analyse ... \n";

    my %words;

    my @wordList = split(/\W/, $content);   # \W trennt auf nicht-Wort-Zeichen
    foreach my $word (@wordList)            # Einzelne Wrter in @wordList
    {        
        if (length($word) > 0)
	{
	    $words{$word} = 0 unless defined $words{$word};
	    $words{$word}++;    # Einklinken in Hash
	}
    }

    my @keys = sort(keys(%words));

    print "Gefundene Woerter ".$#keys." \n";

    foreach my $word (@keys)
    {
        printf ("%4s '$word', ", $words{$word}) if $words{$word} > $minimalCount;
    }

    print "\n";
}

1;
