#perl
#==============================================================================
#
#  Faktories und Mocks
#
#  WordCounter5
#
#  Der Reader laesst einen Web-Reader aus dem Web lesen,
#  den er von einer Factory erzeugen lsst.
#  Die Factory erzeugt er noch selbst.
#  Die Analyse fhrt er dann selbst durch, in einer zweiten Methode
#
#  $content ist nicht zugreifbar!
#
#==============================================================================

use warnings;
use strict;

$|=1;

package WordCounter5;

use WebReader;
use Factory5;

#------------------------------------------------------------------------------
#  Konstruktor
#------------------------------------------------------------------------------
sub new {
    my $self = shift;

    my $type = ref($self)  ||  $self;
    my $elem = bless {}, $type; 
    return $elem;
}

#------------------------------------------------------------------------------
#  Count Words of Web File
#------------------------------------------------------------------------------
sub CountWordsOfWebFile {
    my $self         = shift;
    my $remote_file  = shift;
    my $minimalCount = shift;

    # Die Factory selbst zu erzeugen, das verhindert Mocking!
    my $factory = new Factory5();
    my $webReader = $factory->CreateWebReader();
    my $content = $webReader->ReadWebFile($remote_file);

    $self->Analyse($content, $minimalCount);
}

#------------------------------------------------------------------------------
#  Analysieren der Daten
#------------------------------------------------------------------------------

sub Analyse {
    my $self         = shift;
    my $content      = shift;
    my $minimalCount = shift;

    print "Starte Analyse ... \n";

    my %words;

    my @wordList = split(/\W/, $content);   # \W trennt auf nicht-Wort-Zeichen
    foreach my $word (@wordList)            # Einzelne Wrter in @wordList
    {        
        if (length($word) > 0)
	{
	    $words{$word} = 0 unless defined $words{$word};
	    $words{$word}++;    # Einklinken in Hash
	}
    }

    my @keys = sort(keys(%words));

    print "Gefundene Woerter ".$#keys." \n";

    foreach my $word (@keys)
    {
        printf ("%4s '$word', ", $words{$word}) if $words{$word} > $minimalCount;
    }

    print "\n";
}

1;
